/// Advantage ADO.NET Provider Demo
/// This is a simple application to demonstrate how to perform
/// some basic tasks using the Advantage ADO.NET Provider.
/// Each button of the application performs a different task
/// and updates a Data Grid. 

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Advantage.Data.Provider;

namespace Advantage.Data.Provider.Demo
{
	/// <summary>
	/// Summary description for DemoForm.
	/// </summary>
	public class DemoForm : Form
	{
      private static string m_strTableName = "demo";
      private string m_strDbPath = "";
      private DataSet m_dataSet = null;
      private AdsConnection m_connection = null;
      private AdsDataAdapter m_dataAdapter = null;
      private DataGrid m_dataGrid;
      private PictureBox m_logo;
      private Button m_createButton;
      private Button m_addButton;
      private Button m_changeButton;
      private Button m_updateButton;
      private Button m_deleteButton;
      private Button m_exitButton;
      private CheckBox m_editCheckbox;


		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DemoForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
         System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DemoForm));
         this.m_createButton = new System.Windows.Forms.Button();
         this.m_addButton = new System.Windows.Forms.Button();
         this.m_updateButton = new System.Windows.Forms.Button();
         this.m_changeButton = new System.Windows.Forms.Button();
         this.m_deleteButton = new System.Windows.Forms.Button();
         this.m_dataGrid = new System.Windows.Forms.DataGrid();
         this.m_logo = new System.Windows.Forms.PictureBox();
         this.m_exitButton = new System.Windows.Forms.Button();
         this.m_editCheckbox = new System.Windows.Forms.CheckBox();
         ((System.ComponentModel.ISupportInitialize)(this.m_dataGrid)).BeginInit();
         this.SuspendLayout();
         // 
         // m_createButton
         // 
         this.m_createButton.Location = new System.Drawing.Point(8, 8);
         this.m_createButton.Name = "m_createButton";
         this.m_createButton.Size = new System.Drawing.Size(144, 24);
         this.m_createButton.TabIndex = 0;
         this.m_createButton.Text = "Create &New Table";
         this.m_createButton.Click += new System.EventHandler(this.m_createButton_Click);
         // 
         // m_addButton
         // 
         this.m_addButton.Enabled = false;
         this.m_addButton.Location = new System.Drawing.Point(8, 40);
         this.m_addButton.Name = "m_addButton";
         this.m_addButton.Size = new System.Drawing.Size(144, 24);
         this.m_addButton.TabIndex = 1;
         this.m_addButton.Text = "&Add Some Rows";
         this.m_addButton.Click += new System.EventHandler(this.m_addRowsButton_Click);
         // 
         // m_updateButton
         // 
         this.m_updateButton.Enabled = false;
         this.m_updateButton.Location = new System.Drawing.Point(92, 136);
         this.m_updateButton.Name = "m_updateButton";
         this.m_updateButton.Size = new System.Drawing.Size(60, 24);
         this.m_updateButton.TabIndex = 5;
         this.m_updateButton.Text = "&Update";
         this.m_updateButton.Click += new System.EventHandler(this.m_updateButton_Click);
         // 
         // m_changeButton
         // 
         this.m_changeButton.Enabled = false;
         this.m_changeButton.Location = new System.Drawing.Point(8, 72);
         this.m_changeButton.Name = "m_changeButton";
         this.m_changeButton.Size = new System.Drawing.Size(144, 24);
         this.m_changeButton.TabIndex = 2;
         this.m_changeButton.Text = "Make Some &Changes";
         this.m_changeButton.Click += new System.EventHandler(this.m_changeButton_Click);
         // 
         // m_deleteButton
         // 
         this.m_deleteButton.Enabled = false;
         this.m_deleteButton.Location = new System.Drawing.Point(8, 104);
         this.m_deleteButton.Name = "m_deleteButton";
         this.m_deleteButton.Size = new System.Drawing.Size(144, 24);
         this.m_deleteButton.TabIndex = 3;
         this.m_deleteButton.Text = "&Delete a Row";
         this.m_deleteButton.Click += new System.EventHandler(this.m_deleteButton_Click);
         // 
         // m_dataGrid
         // 
         this.m_dataGrid.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
         this.m_dataGrid.DataMember = "";
         this.m_dataGrid.HeaderForeColor = System.Drawing.SystemColors.ControlText;
         this.m_dataGrid.Location = new System.Drawing.Point(8, 168);
         this.m_dataGrid.Name = "m_dataGrid";
         this.m_dataGrid.ReadOnly = true;
         this.m_dataGrid.Size = new System.Drawing.Size(340, 140);
         this.m_dataGrid.TabIndex = 6;
         // 
         // m_logo
         // 
         this.m_logo.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
         this.m_logo.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
         this.m_logo.Image = ((System.Drawing.Image)(resources.GetObject("m_logo.Image")));
         this.m_logo.Location = new System.Drawing.Point(184, 8);
         this.m_logo.Name = "m_logo";
         this.m_logo.Size = new System.Drawing.Size(163, 39);
         this.m_logo.TabIndex = 6;
         this.m_logo.TabStop = false;
         this.m_logo.Click += new System.EventHandler(this.m_logo_Click);
         // 
         // m_exitButton
         // 
         this.m_exitButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
         this.m_exitButton.Location = new System.Drawing.Point(288, 136);
         this.m_exitButton.Name = "m_exitButton";
         this.m_exitButton.Size = new System.Drawing.Size(60, 24);
         this.m_exitButton.TabIndex = 7;
         this.m_exitButton.Text = "Exit";
         this.m_exitButton.Click += new System.EventHandler(this.m_exitButton_Click);
         // 
         // m_editCheckbox
         // 
         this.m_editCheckbox.Enabled = false;
         this.m_editCheckbox.Location = new System.Drawing.Point(8, 144);
         this.m_editCheckbox.Name = "m_editCheckbox";
         this.m_editCheckbox.Size = new System.Drawing.Size(72, 16);
         this.m_editCheckbox.TabIndex = 4;
         this.m_editCheckbox.Text = "&Edit Grid";
         this.m_editCheckbox.CheckedChanged += new System.EventHandler(this.m_editCheckbox_CheckedChanged);
         // 
         // DemoForm
         // 
         this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
         this.ClientSize = new System.Drawing.Size(356, 317);
         this.Controls.Add(this.m_editCheckbox);
         this.Controls.Add(this.m_exitButton);
         this.Controls.Add(this.m_logo);
         this.Controls.Add(this.m_dataGrid);
         this.Controls.Add(this.m_deleteButton);
         this.Controls.Add(this.m_changeButton);
         this.Controls.Add(this.m_updateButton);
         this.Controls.Add(this.m_addButton);
         this.Controls.Add(this.m_createButton);
         this.Name = "DemoForm";
         this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
         this.Text = "Advantage .NET Data Provider";
         ((System.ComponentModel.ISupportInitialize)(this.m_dataGrid)).EndInit();
         this.ResumeLayout(false);

      }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new DemoForm());
		}

      // Create a new table in the demo directory
      private void m_createButton_Click(object sender, System.EventArgs e)
      {
         Cursor = Cursors.WaitCursor;
         try
         {
            // Get the local path of the demo application.
            // This is where a demo table will be created
            Type myType = typeof(Advantage.Data.Provider.Demo.DemoForm);
            string path = myType.Assembly.CodeBase;
            path = path.ToLower();
            path = path.Replace( "file:///", "" );
            m_strDbPath = path.Replace( "/demo.exe", "" );
    
            // Create a new connection and open it
            m_connection = new AdsConnection( "data source=" + m_strDbPath +
                                    ";tabletype=ads_adt;servertype= local;" );
            m_dataAdapter = new AdsDataAdapter();
            m_connection.Open();

            // If our demo table already exists, delete it.
            System.IO.File.Delete( m_strDbPath + "/" + m_strTableName + ".adt" );

            // Create a new table
            AdsCommand command = new AdsCommand();
            command.Connection = m_connection;
            command.CommandText = "CREATE TABLE "+ m_strTableName +  
               " (ID INTEGER, FirstName CHAR(32)," +
               " LastName CHAR(32), LastUpdate DATE)";
            command.ExecuteNonQuery();

            // Fill the dataset and associate with the Data Grid.
            m_dataAdapter.SelectCommand = 
               new AdsCommand( "select * from " + m_strTableName, m_connection ); 
            m_dataAdapter.TableMappings.Add( m_strTableName, m_strTableName );
            m_dataSet = new DataSet();
            m_dataAdapter.Fill( m_dataSet, m_strTableName );
            m_dataGrid.DataSource = m_dataSet.Tables[m_strTableName];

            // Create update, insert and delete commands
            CreateCommands();

            // Enable the next demo button
            m_createButton.Enabled = false;
            m_addButton.Enabled = true;
         }
         catch ( Exception ex )
         {
            MessageBox.Show("Caught Exception:" + ex.ToString(), "Error",
                       MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
         }
         Cursor = Cursors.Default;
      }

      // Add Insert, Delete and Update Commands to the Data Adapter
      // Called by m_createButton_Click
      private void CreateCommands()
      {

         // Commands may be created directly, or the Command Builder may
         // be used to generate the commands dynamically and automatically. 
         // Whether or not to use the command builder depends on the
         // particular situation. The Command Builder opens a connection, 
         // and may involve unnecessary overhead. On the other hand, it may
         // not be possible to "hard code" the commands as shown below.

         // This method implements the Insert, Delete and Update Commands.


///         Alternatively, the following few lines of code would add a 
///         Command Builder to the Data Adapter and can replace ALL of the 
///         other code in this method by connecting to the table and 
///         automatically generating Insert, Delete and Update Commands.
///    
///         // Use the Command Builder to generate commands
///         AdsCommandBuilder cmdBuilder = new AdsCommandBuilder( this.m_dataAdapter );
///         cmdBuilder.RequirePrimaryKey = false;


         AdsCommand command;
         AdsParameter param;

         // Create INSERT Command
         command = new AdsCommand( "INSERT INTO " + m_strTableName + 
            " (ID, FirstName, LastName, LastUpdate)" +
            " VALUES (:p1, :p2, :p3, :p4)", m_connection );

         // Add parameter list for Update Command for the INSERT Command parameters
         param = new AdsParameter( "p1", DbType.Int32, "ID", DataRowVersion.Current );  
         command.Parameters.Add( param );  
         
         param = new AdsParameter( "p2", DbType.String, "FirstName", DataRowVersion.Current );  
         command.Parameters.Add( param ); 

         param = new AdsParameter( "p3", DbType.String, "LastName", DataRowVersion.Current );  
         command.Parameters.Add( param ); 

         param = new AdsParameter( "p4", DbType.Date, "LastUpdate", DataRowVersion.Current );  
         command.Parameters.Add( param );    

         // Add command to Data Adapter
         m_dataAdapter.InsertCommand = command;


         //Create DELETE Command
         command = new AdsCommand( "DELETE FROM " + m_strTableName + " WHERE" +
            " ID=:p1 AND FirstName=:p2 AND LastName=:p3 AND LastUpdate=:p4",
            m_connection);

         // Add parameter list for the DELETE Command parameters
         // Note that the WHERE clause will use the ORIGINAL value of the field.
         // This is for concurrency to make certain the value has not changed.
         param = new AdsParameter( "p1", DbType.Int32, "ID", DataRowVersion.Original ); 
         command.Parameters.Add( param );  
         
         param = new AdsParameter( "p2", DbType.String, "FirstName", DataRowVersion.Original );  
         command.Parameters.Add( param ); 

         param = new AdsParameter( "p3", DbType.String, "LastName", DataRowVersion.Original ); 
         command.Parameters.Add( param ); 

         param = new AdsParameter( "p4", DbType.Date, "LastUpdate", DataRowVersion.Original ); 
         command.Parameters.Add( param );    
         
         // Add command to Data Adapter
         m_dataAdapter.DeleteCommand = command;


         //Create UPDATE Command
         command = new AdsCommand( "UPDATE " + m_strTableName + 
            " SET ID=:p1, FirstName=:p2, LastName=:p3, LastUpdate=:p4" +
            " WHERE ID=:p5 AND FirstName=:p6 AND LastName=:p7 AND LastUpdate=:p8",
            m_connection);

         // Add parameter list for the UPDATE Command parameters
         // Note that UPDATE clause will use the CURRENT value of the field.
         param = new AdsParameter( "p1", DbType.Int32, "ID", DataRowVersion.Current ); 
         command.Parameters.Add( param );  

         param = new AdsParameter( "p2", DbType.String, "FirstName", DataRowVersion.Current );  
         command.Parameters.Add( param ); 

         param = new AdsParameter( "p3", DbType.String, "LastName", DataRowVersion.Current );  
         command.Parameters.Add( param ); 

         param = new AdsParameter( "p4", DbType.Date, "LastUpdate", DataRowVersion.Current ); 
         command.Parameters.Add( param );    

         // Note that the WHERE clause will use the Original value of the field.
         // This is for concurrency to make certain the value has not changed.
         param = new AdsParameter( "p5", DbType.Int32, "ID", DataRowVersion.Original );  
         command.Parameters.Add( param );  

         param = new AdsParameter( "p6", DbType.String, "FirstName", DataRowVersion.Original );  
         command.Parameters.Add( param ); 

         param = new AdsParameter( "p7", DbType.String, "LastName", DataRowVersion.Original );   
         command.Parameters.Add( param ); 

         param = new AdsParameter( "p8", DbType.Date, "LastUpdate", DataRowVersion.Original );  
         command.Parameters.Add( param );    

         // Add command to Data Adapter
         m_dataAdapter.UpdateCommand = command;
      }
      
      // Add some rows of generic data to the empty table
      private void m_addRowsButton_Click(object sender, System.EventArgs e)
      {
         Cursor = Cursors.WaitCursor;
         try
         {
            DataTable table = m_dataSet.Tables[m_strTableName];

            // Add some rows of generic data to the DataSet
            DataRow row = m_dataSet.Tables[m_strTableName].NewRow();
            row["ID"] = 1;
            row["FirstName"] = "John";
            row["LastName"] = "Smith";
            row["LastUpdate"] = "06/09/1999";
            table.Rows.Add( row );

            row = m_dataSet.Tables[m_strTableName].NewRow();
            row["ID"] = 2;
            row["FirstName"] = "Sue";
            row["LastName"] = "Thomas";
            row["LastUpdate"] = "08/15/2000";
            table.Rows.Add( row );
               
            row = m_dataSet.Tables[m_strTableName].NewRow();
            row["ID"] = 3;
            row["FirstName"] = "Dave";
            row["LastName"] = "Miller";
            row["LastUpdate"] = "12/29/2001";
            table.Rows.Add( row );
               
            row = m_dataSet.Tables[m_strTableName].NewRow();
            row["ID"] = 4;
            row["FirstName"] = "Mary";
            row["LastName"] = "Jones";
            row["LastUpdate"] = "03/14/2000";
            table.Rows.Add( row );

            // Update the database with the modifications to the DataSet 
            int count = m_dataAdapter.Update( m_dataSet, m_strTableName );

            // Enable the next demo button
            m_addButton.Enabled = false;
            m_changeButton.Enabled = true;
         }
         catch ( Exception ex )
         {
            MessageBox.Show("Caught Exception:" + ex.ToString(), "Error",
               MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
         }
         Cursor = Cursors.Default;
      }

      // Make a few changes to the existing data 
      private void m_changeButton_Click(object sender, System.EventArgs e)
      {
         Cursor = Cursors.WaitCursor;
         try
         {
            // Arbitrarily modify some existing rows
            DataTable table = m_dataSet.Tables[m_strTableName];
            table.Rows[0]["FirstName"] = "Ed";
            table.Rows[0]["LastName"] = "Sanders";
            table.Rows[0]["LastUpdate"] = DateTime.Now;

            table.Rows[2]["FirstName"] = "Janet";
            table.Rows[2]["LastName"] = "Andrews";
            table.Rows[2]["LastUpdate"] = DateTime.Now;

            // Update the database with the modifications to the DataSet 
            int count = m_dataAdapter.Update( m_dataSet, m_strTableName );

            // Enable the next demo button
            m_changeButton.Enabled = false;
            m_deleteButton.Enabled = true;
            m_editCheckbox.Enabled = true;

         }
         catch ( Exception ex )
         {
            MessageBox.Show("Caught Exception:" + ex.ToString(), "Error",
            MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
         }
         Cursor = Cursors.Default;
      }

      // Delete the first row of the table
      private void m_deleteButton_Click(object sender, System.EventArgs e)
      {
         Cursor = Cursors.WaitCursor;
         try
         {
            DataTable table = m_dataSet.Tables[m_strTableName];

            // If we have rows left, delete the first
            if( table.Rows.Count > 0 )
            {
               table.Rows[0].Delete();
               // Update the database with the changes 
               m_dataAdapter.Update( m_dataSet, m_strTableName );
            }

            // If all rows deleted, reset to start demo again
            if( table.Rows.Count == 0 )
            {
               m_addButton.Enabled = true;
               m_editCheckbox.Checked = false;
               m_editCheckbox.Enabled = false;
               m_updateButton.Enabled = false;
               m_deleteButton.Enabled = false;
               m_dataGrid.ReadOnly = true;
               // The following fixes an alleged bug in the DataGrid that causes an
               // index exception or error in the DataSet update that started showing
               // up after the DataGrid ReadOnly was dynamically modified.
               if (m_dataGrid.VisibleRowCount >= 0)
                  m_dataGrid.CurrentRowIndex = 0;

               // Clear the table to clear the editable row
               table.Clear();
            }
         }
         catch ( Exception ex )
         {
            MessageBox.Show("Caught Exception:" + ex.ToString(), "Error",
               MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
         }
         Cursor = Cursors.Default;
      }

      // End of the demo - now allow user to freely manipulate data in the grid
      private void m_editCheckbox_CheckedChanged(object sender, System.EventArgs e)
      {
         // If checked, enable editing on the grid
         if ( m_editCheckbox.Checked )
         {
            m_dataGrid.ReadOnly = false;
            m_updateButton.Enabled = true;
            m_deleteButton.Enabled = false;
         }
         else
         {
            // Check for unsaved changes
            DataTable changes = m_dataSet.Tables[m_strTableName].GetChanges();
            if( changes != null )
            {
               if( DialogResult.Yes == MessageBox.Show
                     ( "DataGrid changes have not been updated. Save the changes?",
                       "Changes", MessageBoxButtons.YesNo, MessageBoxIcon.Question ) )
                  m_dataAdapter.Update( m_dataSet, m_strTableName );
               else
                  m_dataSet.Tables[m_strTableName].RejectChanges();
            }
            // Disable editing
            m_dataGrid.ReadOnly = true;
            m_updateButton.Enabled = false;
            m_deleteButton.Enabled = true;
         }
      }

      // Update the table with any changes to the data set.
      private void m_updateButton_Click(object sender, System.EventArgs e)
      {
         // The Data Grid has already done the work for us in saving the
         // changes in the grid. Merely need to call Update on the adapter. 

         Cursor = Cursors.WaitCursor;
         try
         {
            // Update the database with the modifications to the DataSet 
            int count = m_dataAdapter.Update( m_dataSet, m_strTableName );
            // Show the number of rows modified
            if( 0 == count)
               MessageBox.Show( "The data grid can be manually edited by " +
                  "clicking in the fields and manually making changes.", "Update Table",
                  MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
               MessageBox.Show( Convert.ToString(count) + " items updated.", "Update Table",
                  MessageBoxButtons.OK, MessageBoxIcon.Information);

            // Retrieve the data set again and update the data grid
            // This is completely unnecessary, but shows that the update DID occur.
            m_dataAdapter.Fill( m_dataSet);
            m_dataGrid.DataSource = m_dataSet.Tables[m_strTableName];

            // If all deleted, reset to start demo again
            if( m_dataSet.Tables[m_strTableName].Rows.Count == 0 )
            {
               m_addButton.Enabled = true;
               m_editCheckbox.Checked = false;
               m_editCheckbox.Enabled = false;
               m_updateButton.Enabled = false;
               m_deleteButton.Enabled = false;
               m_dataGrid.ReadOnly = true;
            }
         }
         catch ( Exception ex )
         {
            MessageBox.Show("Caught Exception:" + ex.ToString(), "Error",
               MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
         }
         Cursor = Cursors.Default;
      }

      // Close the demo
      private void m_exitButton_Click(object sender, System.EventArgs e)
      {
         if ( m_connection != null && m_connection.State == ConnectionState.Open )
            m_connection.Close();
         Close();
      }

      // Browse to Extended Systems' Advantage Database web site
      private void m_logo_Click(object sender, System.EventArgs e)
      {
         System.Diagnostics.Process process = new System.Diagnostics.Process();
         process.StartInfo.FileName = @"http://www.AdvantageDatabase.com";
         process.StartInfo.UseShellExecute = true;
         process.Start();
      }
	}
}
